package com.mmc.iuav.user.service.signin.impl;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.dao.signin.SignInDao;
import com.mmc.iuav.user.entity.signin.SignInDO;
import com.mmc.iuav.user.entity.signin.SignInRecordDO;
import com.mmc.iuav.user.entity.signin.UserAppSignInDO;
import com.mmc.iuav.user.model.dto.signin.SignInDTO;
import com.mmc.iuav.user.model.vo.signin.AppSignInVO;
import com.mmc.iuav.user.model.vo.signin.SignInVO;
import com.mmc.iuav.user.model.vo.signin.UserContinuousCheckInVO;
import com.mmc.iuav.user.model.vo.userpoints.ChangeUserPointVO;
import com.mmc.iuav.user.service.signin.SignInService;
import com.mmc.iuav.user.service.userpoints.impl.UserPointsServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/10/13 9:34
 * @Version 1.0
 */
@Service
public class SignInServiceImpl implements SignInService {

    @Autowired
    private SignInDao signInDao;

    @Autowired
    private UserPointsServiceImpl userPointsService;

    @Override
    public ResultBody SignIn(SignInVO signInVO) {
        SignInDO signInDO = new SignInDO(signInVO);
        if (signInDO.getId()!=null){
          int update =  signInDao.update(signInDO);
          signInDao.remove(signInDO.getId());
          List<UserContinuousCheckInVO> userContinuousCheckInVO = signInDO.getUserContinuousCheckInVO();
          for (UserContinuousCheckInVO continuousCheckInVO : userContinuousCheckInVO) {
             continuousCheckInVO.setSignInId(signInDO.getId());
             signInDao.CheckIn(continuousCheckInVO);
            }
        }else if(signInDO.getId()==null){
            signInDao.SignIn(signInDO);
            List<UserContinuousCheckInVO> userContinuousCheckInVO = signInDO.getUserContinuousCheckInVO();
            for (UserContinuousCheckInVO continuousCheckInVO : userContinuousCheckInVO) {
                continuousCheckInVO.setSignInId(signInDO.getId());
                signInDao.CheckIn(continuousCheckInVO);
            }
        }

        return ResultBody.success();
    }


    @Override
    public List<SignInDTO> SignInList() {
      List<SignInDO> signInDO=  signInDao.SignInList();
      List<SignInDTO> collect = signInDO.stream().map(SignInDO::buildSignInDTO).collect(Collectors.toList());
        return collect;
    }

    @Override
    public ResultBody appSignIn(AppSignInVO appSignInVO) {
        UserAppSignInDO userAppSignInDO = signInDao.selectUserAppSignIn(appSignInVO);
        List<SignInDO> signInDOS = signInDao.SignInList();
        ChangeUserPointVO changeUserPointVO = new ChangeUserPointVO();
        changeUserPointVO.setUserAccountId(appSignInVO.getUserAccountId());
        changeUserPointVO.setChangeType(4);
        if (userAppSignInDO==null){
            signInDao.userAppSignIn(appSignInVO);
            signInDao.insertSignInRecord(appSignInVO);
            for (SignInDO signInDO : signInDOS) {
                Integer integral = signInDO.getIntegral();
                changeUserPointVO.setChangePoint(integral);
            }
            userPointsService.change(changeUserPointVO);
        }
        if (userAppSignInDO!=null){
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                long time = dateFormat.parse(userAppSignInDO.getSignTime()).getTime();
                long time1 = dateFormat.parse(appSignInVO.getSignTime()).getTime();
                long l =(time1-time)/(24*60*60*1000);
                if (l>1){
                 signInDao.deleteSignInRecord(appSignInVO);
                 signInDao.updateUserAppSignInD(appSignInVO);
                 signInDao.insertSignInRecord(appSignInVO);
                 for (SignInDO signInDO : signInDOS) {
                        changeUserPointVO.setChangePoint(signInDO.getIntegral());
                 }
                 userPointsService.change(changeUserPointVO);
                }else if(l==1){
                    signInDao.updateUserAppSignIn(appSignInVO);
                    signInDao.insertSignInRecord(appSignInVO);
                    UserAppSignInDO userAppSignInDO1 = signInDao.selectUserAppSignIn(appSignInVO);
                    int allPoints=0;
                    for (SignInDO signInDO : signInDOS) {
                        Integer integral = signInDO.getIntegral();
                        List<UserContinuousCheckInVO> userContinuousCheckInVO = signInDO.getUserContinuousCheckInVO();
                        for (UserContinuousCheckInVO continuousCheckInVO : userContinuousCheckInVO) {
                            if (continuousCheckInVO.getNumberOfDays().equals(userAppSignInDO1.getSignInDays())){
                                int bonusPoints = continuousCheckInVO.getBonusPoints();
                                allPoints=integral+bonusPoints;
                                changeUserPointVO.setChangePoint(allPoints);
                            }else if (!continuousCheckInVO.getNumberOfDays().equals(userAppSignInDO1.getSignInDays())){
                                changeUserPointVO.setChangePoint(integral);
                            }
                        }
                    }
                    userPointsService.change(changeUserPointVO);
                }
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return ResultBody.success();
    }

    @Override
    public List<SignInRecordDO> signInRecord(Integer userAccountId) {
        List<SignInRecordDO> signInRecordDOS= signInDao.signInRecord(userAccountId);
        return signInRecordDOS;
    }

}
