package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Insert;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.dto.WebsiteRangeDTO;
import com.mmc.iuav.user.model.qo.ApplyQO;
import com.mmc.iuav.user.model.vo.*;
import com.mmc.iuav.user.service.CooperationService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author: zj @Date: 2023/5/17 21:17
 */
@Api(tags = "合作加盟")
@RequestMapping("/cooperation/")
@RestController
public class CooperationController extends BaseController {
    @Autowired
    private CooperationService cooperationService;

    @ApiOperation(value = "加盟标签列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CooperationTagVO.class)})
    @GetMapping("listTag")
    public ResultBody listTag() {
        return ResultBody.success(cooperationService.listTag());
    }

    @ApiOperation(value = "根据id获取标签信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CooperationTagVO.class)})
    @GetMapping("getTagById")
    public ResultBody getTagById(@RequestParam("id") Integer id) {
        return cooperationService.getTagById(id);
    }

    @ApiOperation(value = "申请加盟")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("apply")
    public ResultBody apply(
            @Validated(value = {Insert.class}) @RequestBody UserApplyTagVO userApplyTagVO,
            HttpServletRequest request) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        userApplyTagVO.setUserAccountId(userAccountId);
        return cooperationService.apply(userApplyTagVO);
    }


    @ApiOperation(value = "app-已申请的品牌与logo列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserApplyTagVO.class)})
    @GetMapping("appBrandList")
    public ResultBody<CompanyInfoVO> appBrandList() {
        return cooperationService.appBrandList();
    }

    @ApiOperation(value = "app-通过用户获取相关品牌信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserApplyTagVO.class)})
    @GetMapping("appBrandMessage")
    public ResultBody<UserApplyTagVO> appBrandMessage(@ApiParam(value = "用户id", required = true) @RequestParam Integer userAccountId) {
        return cooperationService.appBrandMessage(userAccountId);
    }

    @ApiOperation(value = "后台-申请列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserApplyTagVO.class)})
    @PostMapping("listUserApplyTag")
    public ResultBody<UserApplyTagVO> listUserApplyTag(@RequestBody ApplyQO applyQO) {
        return ResultBody.success(cooperationService.listUserApplyTag(applyQO));
    }

    @ApiOperation(value = "后台-获取审核总数")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = AuditSumVO.class)})
    @GetMapping("getAuditSum")
    public ResultBody<AuditSumVO> getAuditSum() {
        return cooperationService.getAuditSum();
    }


    @ApiOperation(value = "后台-编辑服务商信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("editUserApplyTag")
    public ResultBody editUserApplyTag(@RequestBody ApplyTagEditVO applyTagEditVO) {
        return cooperationService.editUserApplyTag(applyTagEditVO);
    }

    @ApiOperation(value = "后台-编辑详情信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ApplyTagEditVO.class)})
    @GetMapping("editUserApplyTagDetails")
    public ResultBody editUserApplyTagDetails(@RequestParam Integer id) {
        return cooperationService.editUserApplyTagDetails(id);
    }

    @ApiOperation(value = "服务商网点数据")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = WebsiteRangeDTO.class)})
    @GetMapping("service/bitmap")
    public ResultBody<WebsiteRangeDTO> listServiceBitmapData(@ApiParam(value = "类型  注：按照渠道标签的id传入即可") @RequestParam Integer type,
                                                             @RequestParam Integer pageNo,
                                                             @RequestParam Integer pageSize,
                                                             @RequestParam Double lon,
                                                             @RequestParam Double lat) {
        return ResultBody.success(cooperationService.listServiceBitmapData(type, pageNo, pageSize, lon, lat));
    }

    @ApiOperation(value = "强制删除加盟商标签")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("deleteApplyTag")
    public ResultBody deleteApplyTag(Integer id) {
        return ResultBody.success(cooperationService.deleteApplyTag(id));
    }

    @ApiOperation(value = "审批详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserApplyTagDetailsVO.class)})
    @GetMapping("applyTagDetails")
    public ResultBody applyTagDetails(
            @RequestParam(value = "id") Integer id,
            @RequestParam(value = "userAccountId") Integer userAccountId) {
        return cooperationService.applyTagDetails(id, userAccountId);
    }

    @ApiOperation(value = "审批")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("approvalApplyTag")
    public ResultBody approvalApplyTag(
            @RequestParam(value = "id") Integer id, @RequestParam(value = "status") Boolean status) {
        return cooperationService.approvalApplyTag(id, status);
    }

    @ApiOperation(value = "后台设置小程序用户标签")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("changeUserTag")
    public ResultBody changeUserTag(
            @Validated(Update.class) @RequestBody UserCooperationTagVO userCooperationTagVO) {
        return cooperationService.changeUserTag(userCooperationTagVO);
    }

    @ApiOperation(value = "获取合作渠道标签", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CooperationTagVO.class)})
    @GetMapping("feignListCooperationTag")
    public List<CooperationTagVO> feignListCooperationTag() {
        return cooperationService.listTag();
    }

    @ApiOperation(value = "合作商家列表-根据合作标签id获取")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CompanyInfoVO.class)})
    @GetMapping("listCompanyInfoByCoopId")
    public ResultBody<CompanyInfoVO> listCompanyInfoByCoopId(@ApiParam(value = "加盟合作标签id") @RequestParam Integer coopId,
                                                             @RequestParam Integer pageNo,
                                                             @RequestParam Integer pageSize,
                                                             @RequestParam Double lon,
                                                             @RequestParam Double lat) {
        return ResultBody.success(cooperationService.listCompanyInfoByCoopId(coopId, pageNo, pageSize, lon, lat));
    }
}
