package com.mmc.iuav.user.service.impl;

import com.github.xiaoymin.knife4j.core.util.CollectionUtils;
import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import com.mmc.iuav.user.dao.CompanyAuthDao;
import com.mmc.iuav.user.dao.CooperationDao;
import com.mmc.iuav.user.entity.*;
import com.mmc.iuav.user.model.qo.ApplyQO;
import com.mmc.iuav.user.model.vo.AttachmentVO;
import com.mmc.iuav.user.model.vo.CooperationTagVO;
import com.mmc.iuav.user.model.vo.UserApplyTagDetailsVO;
import com.mmc.iuav.user.model.vo.UserApplyTagVO;
import com.mmc.iuav.user.model.vo.UserCooperationTagVO;
import com.mmc.iuav.user.service.CooperationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj @Date: 2023/5/17 21:19
 */
@Service
public class CooperationServiceImpl implements CooperationService {
  @Autowired private CooperationDao cooperationDao;

  @Autowired private CompanyAuthDao companyAuthDao;

  @Override
  public List<CooperationTagVO> listTag() {
    List<CooperationTagDO> list = cooperationDao.listTags();
    List<CooperationTagVO> resList =
        list.stream().map(CooperationTagDO::buildCooperationTagVO).collect(Collectors.toList());
    return resList;
  }

  @Override
  public ResultBody apply(UserApplyTagVO userApplyTagVO) {
    int count = cooperationDao.userTagInfo(userApplyTagVO.getCooperationTagId(), userApplyTagVO.getUserAccountId());
    if (count > 0) {
      return ResultBody.error(ResultEnum.TAG_ALREADY_EXIST_ERROR);
    }
    // 判断企业认证
    CompanyAuthDO companyAuthDO = companyAuthDao.getCompanyAuth(userApplyTagVO.getUserAccountId());
    if (companyAuthDO == null) {
      return ResultBody.error(ResultEnum.COMPANY_NOT_AUTH_ERROR);
    }
    UserApplyTagDO userApplyTagDO = new UserApplyTagDO(userApplyTagVO);
    cooperationDao.addApply(userApplyTagDO);
    List<AttachmentVO> attachmentList = userApplyTagVO.getAttachmentList();
    for (AttachmentVO attachmentVO : attachmentList) {
      TagApplyResourceDO tagApplyResourceDO =
          new TagApplyResourceDO(attachmentVO, userApplyTagDO.getId());
      cooperationDao.addApplyResource(tagApplyResourceDO);
    }
    return ResultBody.success();
  }

    @Transactional
    @Override
    public ResultBody changeUserTag(UserCooperationTagVO userCooperationTagVO) {
        // 删除原来的
        cooperationDao.removeUserTag(userCooperationTagVO.getUserAccountId());
        // 添加新的
        if (!CollectionUtils.isEmpty(userCooperationTagVO.getCooperationTagIds())){
            cooperationDao.batchInsertUserTag(userCooperationTagVO.getUserAccountId(), userCooperationTagVO.getCooperationTagIds());
        }
        return ResultBody.success();
    }

  @Override
  public ResultBody getTagById(Integer id) {
    CooperationTagDO cooperationTagDO = cooperationDao.getTagById(id);
    if (cooperationTagDO == null) {
      return ResultBody.success();
    }
    return ResultBody.success(cooperationTagDO.buildCooperationTagVO());
  }

  @Override
  public PageResult listUserApplyTag(ApplyQO applyQO) {
    int count = cooperationDao.countListUserApplyTag(applyQO);
    if (count == 0) {
      return PageResult.buildPage(applyQO.getPageNo(), applyQO.getPageSize(), count);
    }
    int pageNo = applyQO.getPageNo();
    applyQO.buildCurrentPage();
    List<UserApplyTagDO> userApplyTagList = cooperationDao.listUserApplyTag(applyQO);
    List<UserApplyTagVO> list =
        userApplyTagList.stream()
            .map(UserApplyTagDO::buildUserApplyTagVO)
            .collect(Collectors.toList());
    return PageResult.buildPage(pageNo, applyQO.getPageSize(), count, list);
  }

  @Override
  public ResultBody deleteApplyTag(Integer id) {
    cooperationDao.deleteApplyTag(id);
    return ResultBody.success();
  }

  @Override
  public ResultBody applyTagDetails(Integer id, Integer userAccountId) {
    // 初始化返回对象
    UserApplyTagDetailsVO userApplyTagDetailsVO = new UserApplyTagDetailsVO();
    // 获取企业认证信息
    CompanyAuthDO companyAuthDO = companyAuthDao.getCompanyAuth(userAccountId);
    // 获取申请信息
    UserApplyTagDO userApplyTag = cooperationDao.getUserApplyTag(id);
    // 获取附件信息
    List<TagApplyResourceDO> tagApplyResourceList = cooperationDao.getUserApplyResource(id);
    if (CollectionUtils.isNotEmpty(tagApplyResourceList)) {
      List<AttachmentVO> list =
          tagApplyResourceList.stream()
              .map(TagApplyResourceDO::buildAttachmentVO)
              .collect(Collectors.toList());
      userApplyTagDetailsVO.setAttachmentList(list);
    }
    userApplyTagDetailsVO.setCompanyName(companyAuthDO.getCompanyName());
    userApplyTagDetailsVO.setLicenseImg(companyAuthDO.getLicenseImg());
    userApplyTagDetailsVO.setCreditCode(companyAuthDO.getCreditCode());
    userApplyTagDetailsVO.setRemark(userApplyTag.getRemark());
    return ResultBody.success(userApplyTagDetailsVO);
  }

  @Transactional
  @Override
  public ResultBody approvalApplyTag(Integer id, Boolean status) {
    // 判断用户是否已经是该渠道
    UserApplyTagDO userApplyTag = cooperationDao.getUserApplyTag(id);
    int count =
        cooperationDao.userTagInfo(
            userApplyTag.getCooperationTagId(), userApplyTag.getUserAccountId());
    if (status){
      cooperationDao.updateApplyTagStatus(id, 1);
      if (count == 0){
        // 审批通过往用户标签表中新增一条数据
        UserTagDO userTagDO = new UserTagDO();
        userTagDO.setUserAccountId(userApplyTag.getUserAccountId());
        userTagDO.setCooperationTagId(userApplyTag.getCooperationTagId());
        cooperationDao.insertUserTag(userTagDO);
      }
    }else {
      cooperationDao.updateApplyTagStatus(id, 2);
    }
    return ResultBody.success();
  }
}
