package com.mmc.iuav.user.service;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.entity.BackUserAccountDO;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.qo.BUserAccountQO;
import com.mmc.iuav.user.model.vo.BUserAccountVO;
import com.mmc.iuav.user.model.vo.BackUserAccountVO;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/21 15:48
 */
public interface BackUserAccountService {
    /**
     * 添加后台用户
     *
     * @param bUserAccountVO
     * @return
     */
    ResultBody insertBAccount(BUserAccountVO bUserAccountVO);

    /**
     * 添加后台用户信息
     *
     * @param bUserAccountVO
     * @param loginSuccessDTO
     * @return
     */
    ResultBody updateBAccount(BUserAccountVO bUserAccountVO, LoginSuccessDTO loginSuccessDTO);

    /**
     * 禁用后台用户
     *
     * @param accountId
     * @param backUserAccountId
     * @return
     */
    ResultBody disableBAccount(Integer accountId, Integer backUserAccountId);

    /**
     * 后台用户列表
     *
     * @param bUserAccountQO
     * @return
     */
    ResultBody<BackUserAccountVO> listBAccountPage(BUserAccountQO bUserAccountQO);

    /**
     * 内部远程调用查询用户信息
     *
     * @param bUserAccountQO
     * @return
     */
    List<BackUserAccountVO> feignListBAccountPage(BUserAccountQO bUserAccountQO);

    /**
     * 修改用户密码
     *
     * @param account
     * @return
     */
    ResultBody updatePassword(BUserAccountVO account);

    /**
     * 内部确认用户密码
     *
     * @param id
     * @param authPwd
     * @return
     */
    ResultBody feignAuthUserPwd(Integer id, String authPwd);

    /**
     * 登录账号密码查询用户信息
     *
     * @param accountNo
     * @param passWord
     * @return
     */
    BackUserAccountDO getUserLoginInfo(String accountNo, String passWord);
}
