package com.mmc.iuav.user.util;

import com.mmc.iuav.response.ResultBody;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @Author small
 * @Date 2023/7/10 16:24
 * @Version 1.0
 */
@Slf4j
@ControllerAdvice
public class VaildExceptionConfig extends ResultBody {

    @ResponseBody
    @ExceptionHandler(MethodArgumentNotValidException.class)
    public ResultBody throwCustomException(MethodArgumentNotValidException methodArgumentNotValidException) {
        log.error("[ @Vaild异常捕获 ] " + methodArgumentNotValidException.getMessage());
        ResultBody resultBody = new ResultBody();
        resultBody.setCode("400");
        resultBody.setMessage(methodArgumentNotValidException.getBindingResult().getFieldError().getDefaultMessage());
        return resultBody;
    }
}
