package com.mmc.iuav.user.entity.dronepilot;

/**
 * @Author small
 * @Date 2023/8/4 17:05
 * @Version 1.0
 */
public enum SendCertificationMessage {

    COMMITTED(0, "已提交"),
    ALREADY_PASSED(1, "已通过"),
    NOT_PASS(2, "不通过");
    private int code;
    private String message;

    private SendCertificationMessage(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static SendCertificationMessage match(int key) {

        SendCertificationMessage result = null;

        for (SendCertificationMessage s : values()) {
            if (s.getCode() == key) {
                result = s;
                break;
            }
        }

        return result;
    }

    public static SendCertificationMessage catchMessage(String msg) {

        SendCertificationMessage result = null;

        for (SendCertificationMessage s : values()) {
            if (s.getMessage().equals(msg)) {
                result = s;
                break;
            }
        }

        return result;
    }
}
