package com.mmc.iuav.user.model.vo;

import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/7/10 16:02
 * @Version 1.0
 */
@Data
public class RoleInfoVO implements Serializable {
    private static final long serialVersionUID = -5814724843819090363L;
    @ApiModelProperty(value = "角色id", example = "1")
    @NotNull(message = "角色ID不能为空", groups = Update.class)
    private Integer id;
    @ApiModelProperty(value = "角色名称", example = "超级管理员")
    @Size(max = 10, message = "权限角色不得超过10个字符")
    @NotBlank(message = "角色名称不能为空", groups = {Create.class, Update.class})
    private String roleName;
    @ApiModelProperty(value = "备注", example = "备注", required = false)
    @Size(max = 225, message = "备注不得超过225个字符", groups = {Create.class, Update.class})
    private String remark;

}
