package com.mmc.iuav.user.entity.userpoints;

import com.mmc.iuav.user.model.dto.userpoints.UserPointsDetailsDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/5 13:18
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class UserPointsDetails {
    @ApiModelProperty(value = "id不能为空", example = "1")
    private Integer id;

    @ApiModelProperty(value = "用户id", example = "1")
    private Integer userAccountId;

    @ApiModelProperty(value = "积分", example = "5")
    private Integer point;

    @ApiModelProperty(value = "积分来源", example = "注册")
    private String pointSource;

    @ApiModelProperty(value = "积分发放时间", example = "2023-08-05 16:25:02")
    private Date timeOfRelease;

    @ApiModelProperty(value = "创建时间", example = "2023-08-05 16:25:02")
    private Date createTime;

    @ApiModelProperty(value = "更新时间", example = "2023-08-05 16:25:02")
    private Date updateTime;

    @ApiModelProperty(value = "微信昵称", example = "张三")
    private String nickName;

    @ApiModelProperty(value = "手机号", example = "189893132")
    private String phoneNum;

    public UserPointsDetails(Integer userAccountId, Integer point, String message) {
        this.userAccountId = userAccountId;
        this.point = point;
        this.pointSource = message;
    }

    public UserPointsDetailsDTO buildPoint() {
        return UserPointsDetailsDTO.builder()
                .id(this.id)
                .userAccountId(this.userAccountId)
                .point(this.point)
                .pointSource(this.pointSource)
                .timeOfRelease(this.timeOfRelease)
                .createTime(this.createTime)
                .updateTime(this.updateTime)
                .nickName(this.nickName)
                .phoneNum(this.phoneNum)
                .build();
    }
}
