package com.mmc.iuav.user.entity.dronepilot;

import com.alibaba.fastjson2.annotation.JSONField;
import com.mmc.iuav.user.model.dto.dronepilot.PilotCertificationLogDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author small
 * @Date 2023/7/28 10:38
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PilotCertificationLogDO {


    @ApiModelProperty(value = "id", example = "1")
    private Integer id;
    @ApiModelProperty(value = "审批及认证时间", example = "1")
    private Date certificationDate;
    @ApiModelProperty(value = "申请人员的id", example = "1")
    private Integer userAccountId;
    @ApiModelProperty(value = "申请及审批信息", example = "1")
    private String certificationMessage;
    @ApiModelProperty(value = "操作人员id", example = "1")
    private Integer operatorUserId;
    @ApiModelProperty(value = "申请人员的账号名称", example = "1")
    private String userName;
    @ApiModelProperty(value = "手机号", example = "1")
    private String phoneNum;
    @ApiModelProperty(value = "操作人员账号", example = "1")
    private String operatorUserAccount;
    @ApiModelProperty(value = "操作人员名称", example = "1")
    private String operatorUserName;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    public PilotCertificationLogDO(PilotCertificationDO pilotCertificationDO, CertificationMessage certificationMessage) {
        this.userAccountId = pilotCertificationDO.getUserAccountId();
        this.certificationMessage = certificationMessage.getMessage();
    }

    public PilotCertificationLogDO(Integer userAccountId, Integer operatorUserId, CertificationMessage certificationMessage) {
        this.userAccountId = userAccountId;
        this.operatorUserId = operatorUserId;
        this.certificationMessage = certificationMessage.getMessage();
    }

    public PilotCertificationLogDTO buildPlotCertificationLogDTO() {
        return PilotCertificationLogDTO.builder()
                .id(this.id)
                .certificationDate(this.certificationDate)
                .userAccountId(this.userAccountId)
                .certificationMessage(this.certificationMessage)
                .operatorUserId(this.operatorUserId)
                .userName(this.userName)
                .phoneNum(this.phoneNum)
                .operatorUserAccount(this.operatorUserAccount)
                .operatorUserName(this.operatorUserName)
                .createTime(this.createTime)
                .updateTime(this.updateTime)
                .build();
    }

}
