package com.mmc.iuav.user.entity;

import com.alibaba.fastjson2.annotation.JSONField;
import com.mmc.iuav.user.model.vo.RoleInfoVO;
import com.mmc.iuav.user.model.vo.SystemMessageVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author han
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class SystemMessageDO implements Serializable {
    private static final long serialVersionUID = 973044768156590099L;
    /**
     * 消息ID
     */
    private Integer id;
    /**
     * 消息主题
     */
    private String subject;
    /**
     * 消息内容
     */
    private String content;

    /**
     * 是否读过 false为未读 true为已读
     */
    private boolean isRead;
    /**
     * 创建时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;


    public SystemMessageDO(SystemMessageVO message) {
        this.subject = message.getSubject();
        this.content = message.getContent();
    }
}
