package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.UserPartnerDO;
import com.mmc.iuav.user.model.qo.UserPartnerQO;
import com.mmc.iuav.user.model.vo.UserPartnerVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * (UserPartner)表数据库访问层
 *
 * @author makejava
 * @since 2024-03-18 18:05:36
 */
@Mapper
public interface UserPartnerDao {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    UserPartnerVO queryById(Integer id);

    /**
     * 查询指定行数据
     *
     * @param userPartner 查询条件
     * @return 对象列表
     */
    List<UserPartnerVO> queryAllByLimit(UserPartnerQO userPartner);

    /**
     * 统计总行数
     *
     * @param userPartner 查询条件
     * @return 总行数
     */
    int count(UserPartnerQO userPartner);

    /**
     * 新增数据
     *
     * @param userPartnerDO 实例对象
     * @return 影响行数
     */
    int insertPartner(UserPartnerDO userPartnerDO);

    /**
     * 批量新增数据（MyBatis原生foreach方法）
     *
     * @param entities List<UserPartner> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<UserPartnerDO> entities);

    /**
     * 批量新增或按主键更新数据（MyBatis原生foreach方法）
     *
     * @param entities List<UserPartner> 实例对象列表
     * @return 影响行数
     * @throws org.springframework.jdbc.BadSqlGrammarException 入参是空List的时候会抛SQL语句错误的异常，请自行校验入参
     */
    int insertOrUpdateBatch(@Param("entities") List<UserPartnerDO> entities);

    /**
     * 修改数据
     *
     * @param userPartnerDO 实例对象
     * @return 影响行数
     */
    int update(UserPartnerDO userPartnerDO);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Integer id);

}

