package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Insert;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.vo.CompanyAuthVO;
import com.mmc.iuav.user.service.CompanyAuthService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/17 13:33
 */
@Api(tags = "企业认证相关")
@RequestMapping("/company-auth/")
@RestController
public class CompanyAuthController extends BaseController {

    @Autowired
    private CompanyAuthService companyAuthService;

    @ApiOperation(value = "提交企业认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("add")
    public ResultBody add(@Validated(value = {Insert.class}) @RequestBody CompanyAuthVO companyAuthVO, HttpServletRequest request) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        companyAuthVO.setUserAccountId(userAccountId);
        return companyAuthService.add(companyAuthVO);
    }

    @ApiOperation(value = "企业工商模糊搜索")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("fuzzyQueryCompany")
    public ResultBody fuzzyQueryCompany(@ApiParam(value = "企业名称", required = true) @RequestParam String searchKey) {
        return companyAuthService.fuzzyQueryCompany(searchKey);
    }

    @ApiOperation(value = "企业认证详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = CompanyAuthVO.class)})
    @GetMapping("getCompanyAuthInfo")
    public ResultBody getCompanyAuthInfo(@RequestParam Integer userAccountId) {
        return ResultBody.success(companyAuthService.getCompanyAuthByUId(userAccountId));
    }
}
