package com.mmc.iuav.user.model.vo.userpoints;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author small
 * @Date 2023/8/5 15:15
 * @Version 1.0
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserPointsVO {

    @ApiModelProperty(value = "id不能为空", example = "1")
    private Integer id;

    @ApiModelProperty(value = "用户id", example = "1")
    private Integer userAccountId;

    @ApiModelProperty(value = "积分总额", example = "10")
    private Integer totalPoints;


    public UserPointsVO(Integer userAccountId, Integer totalPoints) {
        this.userAccountId = userAccountId;
        this.totalPoints = totalPoints;
    }

}
