package com.mmc.iuav.user.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class MessageTimeVO implements Serializable {
    private static final long serialVersionUID = -1481188328848093579L;

    @ApiModelProperty(value = "购买聊天时长的类型id，唯一识别id", example = "1")
    @NotNull(message = "类型id不能为空")
    private Integer id;

    @ApiModelProperty(value = "微信支付金额，单位（元）", example = "5")
    private BigDecimal money;

    @ApiModelProperty(value = "购买的积分数额", example = "200")
    private Integer points;

    @ApiModelProperty(value = "聊天时长，单位(天)", example = "7")
    private Integer chatDuration;
}
