package com.mmc.iuav.user.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class BuyPointsVO implements Serializable {
    private static final long serialVersionUID = -1481188328848093579L;

    @ApiModelProperty(value = "购买积分类型展示", example = "1")
    @NotNull(message = "类型不能为空")
    private Integer id;
    @ApiModelProperty(value = "微信支付金额", example = "10")
    private BigDecimal money;

    @ApiModelProperty(value = "购买的积分数额", example = "200")
    private Integer points;

    private Date createTime;

    private Date updateTime;
}
