package com.mmc.iuav.user.model.fdd.vo;

import com.mmc.iuav.group.Freeze;
import com.mmc.iuav.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 * @date 2022/8/5 17:19
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SealInfoVO implements Serializable {
    private static final long serialVersionUID = -1288955644357663835L;
    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "端口：0小程序 1后台")
    private Integer port;

    @ApiModelProperty(value = "用户唯一标识", hidden = true)
    private String uId;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
