package com.mmc.iuav.user.model.dto.wallet;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 作者 lw
 * @version 创建时间：2023.8.28 11:08:54
 * @explain 类说明
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WithdrawalApplyDTO implements Serializable {
    private static final long serialVersionUID = -5782430067900145219L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "申请人的用户ID")
    private Integer userAccountId;
    @ApiModelProperty(value = "申请金额")
    private BigDecimal applyAmt;
    @ApiModelProperty(value = "申请状态: 0平台处理中 1提现成功 2提现失败")
    private Integer applyStatus;
    @ApiModelProperty(value = "开户人")
    private String empName;
    @ApiModelProperty(value = "开户银行-支行名称")
    private String bankName;
    @ApiModelProperty(value = "收款账号")
    private String payAccount;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "流水编号")
    private String outerTradeNo;
    @ApiModelProperty(value = "手机号")
    private String phoneNum;
    @ApiModelProperty(value = "提现方式-微信(wechat)-支付宝(alipay)-银行卡(bank_card)", required = true, example = "wechat")
    private String settleType;
    @ApiModelProperty(value = "处理信息")
    private String tradeResult;
    @ApiModelProperty(value = "apply 提现申请 await待发放 handle交易中 success 交易成功 failure 交易失败")
    private String tradeStatus;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

}
