package com.mmc.iuav.user.model.dto.activity;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/10/16 14:49
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ActivityDTO implements Serializable {
    private static final long serialVersionUID = -5184984402965050696L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "活动类型")
    private Integer activityType;
    @ApiModelProperty(value = "活动名称")
    private String activityName;
    @ApiModelProperty(value = "开始时间")
    private Date startTime;
    @ApiModelProperty(value = "结束时间")
    private Date endTime;
    @ApiModelProperty(value = "描述")
    private String description;
    @ApiModelProperty(value = "活动状态：0暂停， 1进行中")
    private Integer activityStatus;
    @ApiModelProperty(value = "奖励类型（0积分，1余额，2优惠券）")
    private Integer rewardType;
    @ApiModelProperty(value = "奖励额度")
    private Integer rewardValue;
    @ApiModelProperty(value = "人数限制")
    private Integer requireNum;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    @ApiModelProperty(value = "活动参与者集合")
    private List<ActivityPartDTO> activityPartDTOS;
}
