package com.mmc.iuav.response;

/**
 * @author: zj
 * @Date: 2023/5/16 10:41
 */
public enum ResultEnum implements BaseErrorInfoInterface {
    SUCCESS("200", "success"),
    BODY_NOT_MATCH("400", "请求的数据格式不符"),
    FAIL("500", "fail"),
    PARAM_ERROR("400", "参数错误"),
    REQUEST_PARAM_ILLEGAL_ERROR("706", "请求参数非法"),
    NOT_FOUND("404", "未找到该资源!"),

    //企业认证
    BUSINESS_LICENSE_CHECK_ANALYSIS_ERROR("1000", "营业执照解析失败，请上传有效清晰的执照"),
    COMPANY_NOT_AUTH_ERROR("1001", "未进行企业认证"),
    BUSINESS_LICENSE_CHECK_PARAMETER_ERROR("1002", "企业信息与营业执照信息不一致，请重新上传"),
    THE_BRAND_NAME_CANNOT_BE_EMPTY("1003", "品牌名称不能为空"),
    THE_BRAND_LOGO_CANNOT_BE_EMPTY("1004", "logo图标不能为空"),
    BUSINESS_LICENSE_CHECK_ERROR("1005", "未进行（企业/个人）认证"),
    BUSINESS_LICENSE_CHECK_NOT_PASS("1006", "（企业/个人）认证未通过"),

    TAG_ALREADY_EXIST_ERROR("2001", "您已拥有该身份，不需要重复提交"),
    TAG_APPLY_ALREADY_EXIST_ERROR("2002", "已存在申请记录，不可重复申请"),

    LOGIN_ACCOUNT_NOT_EXIT_ERROR("5005", "账号不存在"),
    LOGIN_PASSWORD_ERROR("5006", "密码错误"),
    LOGIN_ACCOUNT_STATUS_ERROR("5008", "未登录"),
    REMOVE_COMPANY_BINDING_ERROR("5009", "删除失败，该单位有绑定账号"),
    REMOVE_COMPANY_TASK_ERROR("5010", "删除失败，该单位有绑定服务"),
    COMPANY_NAME_EXIST_ERROR("5011", "单位名称已存在"),
    NOT_BINDING_COMPANY_ERROR("5012", "未绑定企业，绑定公司再重试！"),
    REMOVE_COMPANY_BINDING_APP_ERROR("5013", "删除失败，该单位有绑定小程序账号！"),
    UNBIND_COMPANY_MEMBER_ERROR("5014", "不能解绑管理员"),
    TRANFER_COMPANY_MEMBER_LEADER_ERROR("5015", "转交人不是管理员！"),
    COMPANY_EXIST_ERROR("5015", "该企业已认证！"),
    COOPERATION_CHECK_NOT_PASS_ERROR("5016", "审核失败，请联系管理人员！"),
    REBINDING_COMPANY_ERROR("5017", "该用户已被企业绑定，请尝试让该用户解绑后再重试！"),
    MEMBER_APPLY_ERROR("5018", "企业成员暂不能提交加盟申请！"),
    FORBID_USE_ERROR("5018", "账号禁用"),

    //微信相关
    PASSWORD_INCONSISTENT("5026", "新密码与确认密码不一致，请确认一致"),
    WX_ACCESS_TOKEN_ERROR("5027", "获取微信AccessToken失败"),
    APPLET_QR_CODE_CREATE_ERROR("5030", "生成小程序码错误："),
    AUTH_PHONE_NUMBER_ERROR("5031", "授权手机号失败"),

    PWD_CREATE_ERROR("6001", "创建密码失败"),
    PWD_CONPARED_ERROR("6002", "密码错误"), PWD_ALERT_ERROR("6003", "密码不一致"),
    PWD_REQUEST_AUTH_ERROR("6003", "密码请求验证"),

    APPLET_PORT_TYPE_ERROR("7001", "小程序端口类型错误"),
    APPLET_LOGIN_ERROR("7002", "获取小程序登录信息失败"),
    UPDATE_USER_ACCOUNT_REPEAT("7003", "修改后的账户名已存在"),
    ADD_USER_ACCOUNT_NAME_EXISTS("7004", "新增账户名已经存在"),
    ROLE_NAME_REPEAT_ERROR("8004", "角色名已存在"),
    ROLE_AVL_USER_DELETE_ERROR("8005", "该角色下目前已关联多个用户账号，请先在用户列表中删除角色者账号"),
    UPDATE_ADMIN_ROLE_MENUS_ERROR("8006", "禁止修改超级管理员角色的权限"),
    UPDATE_OWNER_ROLE_MENUS_ERROR("8007", "禁止修改与当前登录账号角色相同的角色权限"),
    UPDATE_OWNER_ROLE_ERROR("8008", "禁止修改当前账号的角色"),
    UPDATE_ADMIN_ROLE_ERROR("8009", "禁止修改admin账号的角色"),
    ONLY_ONE_ADMIN_ERROR("8010", "禁止该账号获取超级管理员角色"),
    DELETE_ADMIN_ERROR("8011", "禁止删除超级管理员角色账号"),
    DELETE_YOURSELF_ERROR("8011", "禁止删除自己的账号"),
    FRANCHISEE_ACCOUNT_MORE_THAN_ONE_ERROR("8012", "绑定企业为加盟公司，禁止使用该单位"),
    NO_RIGHT_UPDATE_ERROR("8013", "无权限操作"),

    ID_INFO_AND_ID_card_MISMATCH("3904", "身份信息与身份证不匹配"),
    INTERFACE_ACCESS_EXCEPTION("36894", "接口访问异常/次数用尽"),
    FRONT_BACK_VAGUE("35556", "身份证正反面不明确"),
    ID_CARD_THOTO_MESSAGE_ERROR("36651", "身份照信息错误"),
    EXPTION_ID_CARD_THOTO_MESSAGE_ERROR("36651", "信息异常"),
    PHOTO_FORMAT_ERROR("12138", "身份证图片格式错误"),
    VALIDATION_INFO_EXPIRED("32815", "认证时间过长信息过期或认证信息不完整，请重新开始认证"),
    REAL_IMAGE_AUTHENTICATION_SUCESS("38844", "验证成功"),
    REAL_IMAGE_AUTHENTICATION_FAILED("38855", "验证失败，请再次进行人脸识别"),
    IDENTITY_HAS_BEEN_AUTHENTICATED("34444", "此身份证信息已经被认证，已经帮你更换为当前用户"),
    REAL_NAME_ACCOUNT_ID_ERROR("36771", "账户id错误"),
    REAL_NAME_FUSING_ERROR("36772", "认证失败，请重新认证"),

    REAL_NAME_PASS_ERROR("36773", "已成功认证"),
    PLEASE_ERFORM_REAL_NAME_AUTHENTICATION_FIRST("36774", "请先进行实名认证"),
    I_HAVE_APPLIED_FOR_A_PILOT_LICENSE("36775", "已经申请飞手执照及能力认证，请等待审核"),
    CAN_NOT_CHANGE_THE_APPLICATION_OF_OTHERS("36776", "不能变更其他人申请的飞手执照及电子认证"),
    WX_NOT_SEND_MSG_PARAM_ERROR("5029", "userId和openId至少一个不为空"),
    APPLET_USER_ACCESS_TOKE_ERROR("5031", "获取accessToken签名校验失败"),
    WX_NOT_REL_ERROR("5028", "获取微信公众号用户信息失败"),
    DELETE_PASS_ERROR("5029", "已通过认证的不可删除"),

    // 提现相关
    WITHDRAWAL_APPLY_STATUS_ERROR("40001", "审批状态有误"),
    WITHDRAWAL_INFO_NOT_FIND_ERROR("40002", "提现申请单信息不存在"),
    WITHDRAWAL_REPEAT_CHECK_ERROR("40003", "提现申请单已被审批，切勿重复审批。");

    /**
     * 错误码
     *
     * @return
     */
    String resultCode;

    /**
     * 错误描述
     *
     * @return
     */
    String resultMsg;

    ResultEnum(String resultCode, String resultMsg) {
        this.resultCode = resultCode;
        this.resultMsg = resultMsg;
    }

    @Override
    public String getResultCode() {
        return this.resultCode;
    }

    @Override
    public String getResultMsg() {
        return this.resultMsg;
    }
}
