package com.mmc.iuav.user.model.qo.wallet;
/**
 * @author 作者 geDuo
 * @version 创建时间：2021年10月29日 下午2:25:08
 * @explain 类说明
 */

import com.mmc.iuav.group.Freeze;
import com.mmc.iuav.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class WithdrawalApplyQO implements Serializable {

    private static final long serialVersionUID = -2185498289462506967L;

    @ApiModelProperty(value = "关键字", example = "666")
    private String keyword;

    @ApiModelProperty(value = "开始时间", example = "2023-08-28 00:00:00")
    private String startTime;

    @ApiModelProperty(value = "结束时间", example = "2023-08-28 23:59:59")
    private String endTime;

    @ApiModelProperty(value = "状态: apply 提现申请 await待发放 handle交易中 success 交易成功 failure 交易失败", example = "0")
    private String tradeStatus;

    @ApiModelProperty(value = "通道标识-微信(wechat)-支付宝(alipay)-银行卡(bank_card)", required = true, example = "wechat")
    private String settleType;

    @ApiModelProperty(value = "页码", required = true, example = "1")
    @NotNull(message = "页码不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true, example = "10")
    @NotNull(message = "每页显示数不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
