package com.mmc.iuav.user.service.impl;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.dao.MenuInfoDao;
import com.mmc.iuav.user.entity.MenuInfoDO;
import com.mmc.iuav.user.model.dto.MenuInfoDTO;
import com.mmc.iuav.user.service.MenuInfoService;
import com.mmc.iuav.user.util.MenuTreeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/7/11 14:14
 */
@Service
public class MenuInfoServiceImpl implements MenuInfoService {
    @Autowired
    private MenuInfoDao menuInfoDao;

    @Override
    public ResultBody listMenuInfo() {
        List<MenuInfoDO> menuInfoDOList = menuInfoDao.listMenuInfo();
        List<MenuInfoDTO> menuInfoDTOS = menuInfoDOList.stream().map(MenuInfoDO::buildMenuInfoDTO).collect(Collectors.toList());
        return ResultBody.success(MenuTreeUtil.buildTreePCMenu(menuInfoDTOS));
    }

}
