package com.mmc.iuav.user.controller.activity;

import com.mmc.iuav.group.Insert;
import com.mmc.iuav.group.Page;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.dto.activity.ActivityDTO;
import com.mmc.iuav.user.model.qo.ActivityQO;
import com.mmc.iuav.user.model.vo.activity.ActivityVO;
import com.mmc.iuav.user.service.ActivityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author: zj
 * @Date: 2023/10/16 15:06
 */
@Api(tags = "活动管理")
@RequestMapping("/activity/")
@RestController
public class ActivityController extends BaseController {
    @Autowired
    private ActivityService activityService;

    @ApiOperation(value = "添加活动")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insert")
    public ResultBody insertActivity(@Validated(Insert.class) @RequestBody ActivityVO activity) {
        return activityService.insertActivity(activity);
    }

    @ApiOperation(value = "修改活动")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("update")
    public ResultBody updateActivity(@Validated(Update.class) @RequestBody ActivityVO activity) {
        return activityService.updateActivity(activity);
    }

    @ApiOperation(value = "活动详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ActivityDTO.class)})
    @GetMapping("details")
    public ResultBody details(@RequestParam Integer id) {
        return activityService.details(id);
    }

    @ApiOperation(value = "删除活动")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("delete")
    public ResultBody delete(@RequestParam Integer id) {
        return activityService.delete(id);
    }

    @ApiOperation(value = "活动列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("listActivityPages")
    public ResultBody listActivityPages(@Validated(Page.class) @RequestBody ActivityQO activityQO) {
        return activityService.listActivityPages(activityQO);
    }

    @ApiOperation(value = "活动邀请详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("inviteDetail")
    public ResultBody inviteDetail(@Validated(Page.class) @RequestBody ActivityQO activityQO) {
        return activityService.inviteDetail(activityQO);
    }

}
