package com.mmc.iuav.user.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/8/21 13:40
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class XzAuthVO implements Serializable {
    private static final long serialVersionUID = -6009105206194794410L;
    @ApiModelProperty(value = "用户名称")
    private String username;
    @ApiModelProperty(value = "身份证号")
    private String idCardNo;
    @ApiModelProperty(value = "手机号码")
    private String mobile;
    @ApiModelProperty(value = "附加信息，如需4要素认证必填")
    private String bankAccount;
    @ApiModelProperty(value = "身份证照片人像面URL，图片必须已经通过OCR识别")
    private String idCardImageFront;
    @ApiModelProperty(value = "身份证照片国徽面URL，图片必须已经通过OCR识别")
    private String idCardImageBack;

}
