package com.mmc.iuav.user.model.qo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.domain.Page;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/10/16 15:23
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ActivityQO implements Serializable {
    private static final long serialVersionUID = -5184984402962050696L;

    @ApiModelProperty(value = "活动id")
    private Integer activityId;

    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;

    @ApiModelProperty(value = "活动类型（0用户邀请活动）")
    private Integer activityType;

    @ApiModelProperty(value = "活动状态：0暂停， 1进行中")
    private Integer activityStatus;

    @ApiModelProperty(value = "页码", required = true, example = "1")
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true, example = "10")
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
