package com.mmc.iuav.user.model.fdd.vo;

import com.mmc.iuav.group.Insert;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 * @date 2022/9/5 14:40
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ContractVO implements Serializable {
    private static final long serialVersionUID = 570570471824495498L;
    @ApiModelProperty(value = "合同地址", required = true)
    @NotNull(message = "合同地址不能为空", groups = {Insert.class})
    private String docUrl;

    @ApiModelProperty(value = "订单编号", required = true)
    @NotNull(message = "订单编号不能为空", groups = {Insert.class})
    private String orderNo;

    @ApiModelProperty(value = "合同标题", required = true)
    @NotNull(message = "合同标题不能为空", groups = {Insert.class})
    private String title;

    @ApiModelProperty(value = "端口：0小程序 1后台", required = true)
    private Integer port;

    @ApiModelProperty(value = "unionId", hidden = true)
    private String unionId;
}
