package com.mmc.iuav.response;

/**
 * @author: zj
 * @Date: 2023/5/16 10:41
 */
public enum ResultEnum implements BaseErrorInfoInterface{
    SUCCESS("200", "success"),
    FAIL("500", "fail"),
    PARAM_ERROR("400", "参数错误"),

    //企业认证
    BUSINESS_LICENSE_CHECK_ANALYSIS_ERROR("1000", "营业执照解析失败，请上传有效清晰的执照"),
    COMPANY_NOT_AUTH_ERROR("1001", "未进行企业认证"),
    BUSINESS_LICENSE_CHECK_PARAMETER_ERROR("1002", "企业信息与营业执照信息不一致，请重新上传"),

    TAG_ALREADY_EXIST_ERROR("2001", "您已拥有该身份，不需要重复提交"),

    LOGIN_ACCOUNT_NOT_EXIT_ERROR("5005", "账号不存在"),
    LOGIN_PASSWORD_ERROR("5006", "密码错误"),
    LOGIN_ACCOUNT_STATUS_ERROR("5008", "未登录"),
    REMOVE_COMPANY_BINDING_ERROR("5009", "删除失败，该单位存在绑定的账号"),
    REMOVE_COMPANY_TASK_ERROR("5010", "删除失败，该单位存在绑定的服务"),

    //微信相关
    PASSWORD_INCONSISTENT("5026", "新密码与确认密码不一致，请确认一致"),
    WX_ACCESS_TOKEN_ERROR("5027", "获取微信AccessToken失败"),
    APPLET_QR_CODE_CREATE_ERROR("5030", "生成小程序码错误："),
    AUTH_PHONE_NUMBER_ERROR("5031", "授权手机号失败"),

    PWD_CREATE_ERROR("6001", "创建密码失败"),
    PWD_CONPARED_ERROR("6002", "密码错误"), PWD_ALERT_ERROR("6003", "密码不一致"),
    PWD_REQUEST_AUTH_ERROR("6003", "密码请求验证"),



    APPLET_PORT_TYPE_ERROR("7001", "小程序端口类型错误"),
    APPLET_LOGIN_ERROR("7002", "获取小程序登录信息失败"),
    UPDATE_USER_ACCOUNT_REPEAT("7003", "修改后的账户名已存在"),
    ADD_USER_ACCOUNT_NAME_EXISTS("7004", "新增账户名已经存在");

    /**
     * 错误码
     *
     * @return
     */
    String resultCode;

    /**
     * 错误描述
     *
     * @return
     */
    String resultMsg;

    ResultEnum(String resultCode, String resultMsg) {
        this.resultCode = resultCode;
        this.resultMsg = resultMsg;
    }

    @Override
    public String getResultCode() {
        return this.resultCode;
    }

    @Override
    public String getResultMsg() {
        return this.resultMsg;
    }
}
