package com.mmc.iuav.user.service.impl;

import com.mmc.iuav.general.CodeUtil;
import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import com.mmc.iuav.user.dao.RoleDao;
import com.mmc.iuav.user.entity.RoleInfoDO;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.qo.RoleInfoQO;
import com.mmc.iuav.user.model.vo.RoleInfoVO;
import com.mmc.iuav.user.service.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/7/10 16:05
 * @Version 1.0
 */
@Service
public class RoleServiceImpl implements RoleService {


    @Autowired
    private RoleDao roleDao;

    @Override
    public ResultBody insertRoleInfo(RoleInfoVO roleInfo, LoginSuccessDTO userLoginInfoFromRedis) {
        int count = roleDao.countRoleName(roleInfo.getRoleName());
        if (count > 0) {
            return ResultBody.error(ResultEnum.ROLE_NAME_REPEAT_ERROR);
        }
        RoleInfoDO rd = new RoleInfoDO(roleInfo);
        rd.setUserAccountId(userLoginInfoFromRedis.getUserAccountId());
        rd.setRoleNo(CodeUtil.createRoleNo());
        roleDao.insertRoleInfo(rd);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateRoleInfo(RoleInfoVO roleInfo, LoginSuccessDTO userLoginInfoFromRedis) {
        RoleInfoDO rd = new RoleInfoDO(roleInfo);
        int count = roleDao.countRoleNameId(rd);
        if (count > 0) {
            return ResultBody.error(ResultEnum.ROLE_NAME_REPEAT_ERROR);
        }
        rd.setUserAccountId(userLoginInfoFromRedis.getUserAccountId());
        roleDao.updateRoleInfo(rd);
        return ResultBody.success();
    }

    @Override
    public ResultBody removeRoleInfo(Integer id) {
        Integer count = roleDao.countNotDelUserAccountByRole(id);
        if (count > 0) {
            return ResultBody.error(ResultEnum.ROLE_AVL_USER_DELETE_ERROR);
        }
        roleDao.removeRoleInfo(id);
        return ResultBody.success();
    }

    @Override
    public PageResult listPageRoleInfo(RoleInfoQO param, LoginSuccessDTO userLoginInfoFromRedis) {
        int count = roleDao.countPageRoleInfo(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        return PageResult.buildPage(pageNo, param.getPageSize(), count,
                roleDao.listPageRoleInfo(param).stream().map(d -> {
                    return d.buildRoleInfoDTO();
                }).collect(Collectors.toList()));
    }


}
