package com.mmc.iuav.user.service.impl;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.dao.MenuInfoDao;
import com.mmc.iuav.user.dao.RoleDao;
import com.mmc.iuav.user.entity.MenuInfoDO;
import com.mmc.iuav.user.entity.RoleInfoDO;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.dto.MenuInfoDTO;
import com.mmc.iuav.user.model.vo.RoleMenuInfoVO;
import com.mmc.iuav.user.service.MenuInfoService;
import com.mmc.iuav.user.util.MenuTreeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/7/11 14:14
 */
@Service
public class MenuInfoServiceImpl implements MenuInfoService {
    @Autowired
    private MenuInfoDao menuInfoDao;

    @Autowired
    private RoleDao roleDao;

    @Transactional
    @Override
    public ResultBody updateRoleMenuInfo(RoleMenuInfoVO roleMenuInfoVO, LoginSuccessDTO loginSuccessDTO) {
        // 判断该角色的菜单是否可以修改
        RoleInfoDO roleInfo = roleDao.getRoleInfo(roleMenuInfoVO.getRoleId());
        if (!CollectionUtils.isEmpty(roleMenuInfoVO.getMenuInfoIds())) {
            List<MenuInfoDO> menuInfoDOList = menuInfoDao.listRoleMenuInfo(roleMenuInfoVO.getRoleId());
            List<Integer> existMenuIds = menuInfoDOList.stream().map(MenuInfoDO::getId).collect(Collectors.toList());
            // 新添加的权限
            List<Integer> addMenuIds = roleMenuInfoVO.getMenuInfoIds().stream().filter(v -> !existMenuIds.contains(v)).collect(Collectors.toList());
            // 需删除的权限
            List<Integer> deleteMenuIds = existMenuIds.stream().filter(v -> !roleMenuInfoVO.getMenuInfoIds().contains(v)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(addMenuIds)) {
                menuInfoDao.batchAddMenuIds(roleMenuInfoVO.getRoleId(), addMenuIds);
            }
            if (!CollectionUtils.isEmpty(deleteMenuIds)) {
                menuInfoDao.batchDeleteMenuIds(roleMenuInfoVO.getRoleId(), deleteMenuIds);
            }
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody listMenuInfo() {
        List<MenuInfoDO> menuInfoDOList = menuInfoDao.listMenuInfo();
        List<MenuInfoDTO> menuInfoDTOS = menuInfoDOList.stream().map(MenuInfoDO::buildMenuInfoDTO).collect(Collectors.toList());
        return ResultBody.success(MenuTreeUtil.buildTreePCMenu(menuInfoDTOS));
    }

    @Override
    public ResultBody listRoleMenuInfo(Integer roleId) {
        List<MenuInfoDO> menuInfoDOList = menuInfoDao.listRoleMenuInfo(roleId);
        List<MenuInfoDTO> menuInfoDTOS = menuInfoDOList.stream().map(MenuInfoDO::buildMenuInfoDTO).collect(Collectors.toList());
        return ResultBody.success(MenuTreeUtil.buildTreePCMenu(menuInfoDTOS));
    }
}
