package com.mmc.iuav.user.controller;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.dto.MenuInfoDTO;
import com.mmc.iuav.user.model.vo.RoleMenuInfoVO;
import com.mmc.iuav.user.service.MenuInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/7/11 14:09
 */
@Api(tags = "角色菜单管理")
@RequestMapping("/role-menu/")
@RestController
public class MenuInfoController extends BaseController {
    @Autowired
    private MenuInfoService menuInfoService;

    @ApiOperation(value = "全部菜单列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MenuInfoDTO.class)})
    @GetMapping("listMenuInfo")
    public ResultBody listMenuInfo() {
        return menuInfoService.listMenuInfo();
    }

    @ApiOperation(value = "根据角色id获取权限")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MenuInfoDTO.class)})
    @GetMapping("listRoleMenuInfo")
    public ResultBody listRoleMenuInfo(@RequestParam Integer roleId) {
        return menuInfoService.listRoleMenuInfo(roleId);
    }

    @ApiOperation(value = "修改角色菜单权限")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updateRoleMenuInfo")
    public ResultBody updateRoleMenuInfo(HttpServletRequest request, @RequestBody RoleMenuInfoVO roleMenuInfoVO) {
        return menuInfoService.updateRoleMenuInfo(roleMenuInfoVO, this.getUserLoginInfoFromRedis(request));
    }
}
