package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.CooperationTagDO;
import com.mmc.iuav.user.entity.UserApplyTagDO;
import com.mmc.iuav.user.entity.UserTagDO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/17 21:20
 */
@Mapper
public interface CooperationDao {
    /**
     * 加盟标签列表
     * @return
     */
    List<CooperationTagDO> listTags();

    /**
     * 加盟申请
     * @param userApplyTagDO
     */
    void addApply(UserApplyTagDO userApplyTagDO);

    /**
     * 根据用户id获取合作申请
     * @param userAccountId
     * @return
     */
    UserApplyTagDO getUserApplyTag(Integer userAccountId);

    /**
     * 修改用户申请
     * @param userApplyTagDO
     */
    void updateUserApplyTag(UserApplyTagDO userApplyTagDO);

    /**
     * 根据用户id查询渠道登记
     * @param userAccountId
     * @return
     */
    UserTagDO getUserTag(Integer userAccountId);

    /**
     * 用户设置渠道等级
     * @param userTagDO
     */
    void insertUserTag(UserTagDO userTagDO);

    /**
     * 修改用户渠道等级
     * @param userTagDO
     */
    void updateUserTag(UserTagDO userTagDO);
}
