package com.mmc.iuav.user.controller;

import com.mmc.iuav.auth.JwtConstant;
import com.mmc.iuav.auth.JwtUtil;
import com.mmc.iuav.http.BizException;
import com.mmc.iuav.user.model.dto.BaseAccountDTO;
import io.jsonwebtoken.Claims;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/25 18:11
 */
public abstract class BaseController {

    /**
     * 解析token，获取用户信息
     * @param request
     * @return
     */
    public BaseAccountDTO getUserLoginInfo(HttpServletRequest request) {
        String token = request.getHeader("token");
        try {
            Claims claims = JwtUtil.parseJwt(token);
            String userId = claims.get(JwtConstant.USER_ACCOUNT_ID).toString();
//        String roleId = claims.get("").toString();
            String tokenType = claims.get(JwtConstant.TOKEN_TYPE).toString();
            return BaseAccountDTO.builder().id(Integer.parseInt(userId)).tokenPort(tokenType).build();
        }catch (Exception e){
            throw new BizException("Invalid token");
        }
    }
}
