package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.vo.UserRcdVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/6/6 17:13
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserRcdDO implements Serializable {
    private static final long serialVersionUID = 5407029715338119583L;
    private Integer id;
    /**
     * 用户id(推荐接受人)
     */
    private Integer userAccountId;
    /**
     * 邀请人id（发起人）
     */
    private Integer rcdUserId;
    /**
     * 邀请人昵称（发起人）
     */
    private String rcdNickname;
    /**
     * 邀请人姓名（发起人）
     */
    private String rcdUserName;
    private String remark;
    private Date createTime;

    public UserRcdVO buildUserRcdVO() {
        return UserRcdVO.builder().id(this.id).userAccountId(this.userAccountId).rcdUserId(this.rcdUserId).rcdNickname(this.rcdNickname)
                .rcdUserName(this.rcdUserName).remark(this.remark).createTime(this.createTime).build();
    }
}
