package com.mmc.iuav.user.service.impl;

import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.dao.CompanyAuthDao;
import com.mmc.iuav.user.dao.CompanyDao;
import com.mmc.iuav.user.entity.CompanyAuthDO;
import com.mmc.iuav.user.entity.CompanyInfoDO;
import com.mmc.iuav.user.model.qo.CompanyInfoQO;
import com.mmc.iuav.user.model.vo.CompanyInfoVO;
import com.mmc.iuav.user.service.CompanyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/7/3 15:39
 */
@Service
public class CompanyServiceImpl implements CompanyService {

    @Autowired
    private CompanyDao companyDao;

    @Override
    public ResultBody addCompanyInfo(CompanyInfoVO companyInfo) {
        CompanyInfoDO companyInfoDO = new CompanyInfoDO(companyInfo);
        companyDao.addCompanyInfo(companyInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody removeCompanyInfo(Integer id) {
        companyDao.removeCompanyInfo(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateCompanyInfo(CompanyInfoVO companyInfo) {
        CompanyInfoDO companyInfoDO = new CompanyInfoDO(companyInfo);
        companyDao.updateCompanyInfo(companyInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody getCompanyInfoById(Integer id) {
        CompanyInfoDO companyInfoDO = companyDao.getCompanyInfoById(id);
        if (companyInfoDO != null){
            return ResultBody.success(companyInfoDO.buildCompanyInfoVO());
        }
        return null;
    }

    @Override
    public ResultBody<CompanyInfoVO> listCompanyPage(CompanyInfoQO param) {
        int count = companyDao.countListCompanyPage(param);
        if (count == 0){
            return ResultBody.success(PageResult.buildPage(param.getPageNo(), param.getPageSize(), count));
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<CompanyInfoDO> companyInfoDOS = companyDao.listCompanyPage(param);
        List<CompanyInfoVO> companyInfoVOList = companyInfoDOS.stream().map(CompanyInfoDO::buildCompanyInfoVO).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, param.getPageSize(), count, companyInfoVOList));
    }

    @Override
    public CompanyInfoVO getCompanyInfoByBackUserAccountId(Integer backUserAccountId) {
        CompanyInfoDO companyInfoDO = companyDao.getCompanyInfoByBackUserAccountId(backUserAccountId);
        if (companyInfoDO != null) {
            return companyInfoDO.buildCompanyInfoVO();
        }
        return null;
    }
}
