package com.mmc.iuav.user.service;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.entity.CompanyInfoDO;
import com.mmc.iuav.user.model.qo.CompanyInfoQO;
import com.mmc.iuav.user.model.vo.CompanyInfoVO;

/**
 * @author: zj
 * @Date: 2023/7/3 15:39
 */
public interface CompanyService {
    /**
     * 新增
     * @param companyInfo
     * @return
     */
    ResultBody addCompanyInfo(CompanyInfoVO companyInfo);

    /**
     * 移除
     * @param id
     * @return
     */
    ResultBody removeCompanyInfo(Integer id);

    /**
     * 修改
     * @param companyInfo
     * @return
     */
    ResultBody updateCompanyInfo(CompanyInfoVO companyInfo);

    /**
     * 单位查询
     * @param id
     * @return
     */
    ResultBody getCompanyInfoById(Integer id);

    /**
     * 单位列表
     * @param companyInfoQO
     * @return
     */
    ResultBody<CompanyInfoVO> listCompanyPage(CompanyInfoQO companyInfoQO);

    /**
     * 通过用户id获取单位信息
     * @param backUserAccountId
     * @return
     */
    CompanyInfoVO getCompanyInfoByBackUserAccountId(Integer backUserAccountId);
}
