package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.CompanyInfoDO;
import com.mmc.iuav.user.model.qo.CompanyInfoQO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/7/3 15:39
 */
@Mapper
public interface CompanyDao {
    /**
     * 添加单位
     * @param companyInfoDO
     */
    void addCompanyInfo(CompanyInfoDO companyInfoDO);

    /**
     * 移除单位
     * @param id
     */
    void removeCompanyInfo(Integer id);

    /**
     * 修改单位
     * @param companyInfoDO
     */
    void updateCompanyInfo(CompanyInfoDO companyInfoDO);

    /**
     * 单位查询
     * @param id
     * @return
     */
    CompanyInfoDO getCompanyInfoById(Integer id);

    /**
     * 单位数量查询
     * @param param
     * @return
     */
    int countListCompanyPage(CompanyInfoQO param);

    /**
     * 单位列表
     * @param param
     * @return
     */
    List<CompanyInfoDO> listCompanyPage(CompanyInfoQO param);

    /**
     * 通过用户ID获取单位信息
     * @param backUserAccountId
     * @return
     */
    CompanyInfoDO getCompanyInfoByBackUserAccountId(Integer backUserAccountId);
}
