package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.BackUserAccountDO;
import com.mmc.iuav.user.model.qo.BUserAccountQO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/21 15:33
 */
@Mapper
public interface BackUserAccountDao {
    /**
     * 添加后台用户
     * @param backUserAccountDO
     */
    void insertBackUserAccount(BackUserAccountDO backUserAccountDO);

    /**
     * 修改后台用户
     * @param backUserAccountDO
     */
    void updateBackUserAccount(BackUserAccountDO backUserAccountDO);

    /**
     * 查看用户详情
     * @param backUserAccountId
     * @return
     */
    BackUserAccountDO getBackUserAccountDO(Integer backUserAccountId);

    /**
     * 查询符合条件的用户个数
     * @param bUserAccountQO
     * @return
     */
    int countListBackUserAccount(BUserAccountQO bUserAccountQO);

    /**
     * 查询符合条件的用户信息
     * @param bUserAccountQO
     * @return
     */
    List<BackUserAccountDO> listBackUserAccount(BUserAccountQO bUserAccountQO);

    /**
     * 删除用户信息
     * @param id
     */
    void removeBackUserAccountDO(Integer id);

    /**
     * 远程调用查询用户信息
     * @param bUserAccountQO
     * @return
     */
    List<BackUserAccountDO> feignListBackUserAccount(BUserAccountQO bUserAccountQO);

    /**
     * 验证用户密码
     * @param id
     * @return
     */
    BackUserAccountDO getAuthUserPwd(Integer id);

    /**
     * 登录账号密码查询用户信息
     * @param accountNo
     * @param passWord
     * @return
     */
    BackUserAccountDO getUserLoginInfo(String accountNo, String passWord);

    /**
     * 修改用户密码
     * @param id
     * @param passWord
     */
    void updatePassword(Integer id, String passWord);

    /**
     * 根据账号名称查询数量
     * @param excludeId
     * @param accountNo
     * @return
     */
    int countUserAccountNo(Integer excludeId, String accountNo);
}
