package com.mmc.iuav.user.controller.fdd;

import com.mmc.iuav.group.Insert;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.fdd.dto.ContractInfoDTO;
import com.mmc.iuav.user.model.fdd.vo.ContractVO;
import com.mmc.iuav.user.service.fdd.ContractService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * @Author LW
 * @date 2022/9/5 14:31
 * 概要：
 */
@Api(tags = {"合同管理"})
@RestController
@RequestMapping("/fdd/contract/")
public class ContractController extends BaseController {
    @Autowired
    private ContractService contractService;

    @ApiOperation(value = "上传合同")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/uploadContract")
    public ResultBody uploadContract(@Validated(value = {Insert.class}) @RequestBody ContractVO param, HttpServletRequest request) {
        return contractService.uploadContract(param, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "合同预览")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/viewContract")
    public ResultBody viewContract(@ApiParam(value = "合同编号") @RequestParam(value = "contractId") String contractId) {
        return contractService.viewContract(contractId);
    }

    @ApiOperation(value = "下载合同")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/downloadContract")
    public ResultBody downloadContract(@ApiParam(value = "合同编号") @RequestParam(value = "contractId") String contractId) {
        return contractService.downloadContract(contractId);
    }

    @ApiOperation(value = "手动签署")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/stamp")
    public ResultBody stamp(@ApiParam(value = "合同编号") @RequestParam(value = "contractId") String contractId,
                            @ApiParam(value = "小程序页面跳转地址") @RequestParam(value = "pages", required = false) String pages,
                            HttpServletRequest request, @ApiParam(value = "端口：0小程序 1后台") @RequestParam(value = "port") Integer port,
                            @ApiParam(value = "认证类型") @RequestParam(value = "customerId", required = false) String customerId) {
        return contractService.stamp(contractId, this.getUserLoginInfoFromRedis(request), pages, port, customerId);
    }

    @ApiOperation(value = "异步处理手动签署信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("notifyStamp")
    @ApiIgnore
    public ResultBody notifyStamp(@RequestParam Map<String, String> map) {
        return contractService.notifyStamp(map);
    }

    @ApiOperation(value = "归档")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/file")
    public ResultBody file(@ApiParam(value = "合同编号") @RequestParam(value = "contractId") String contractId,
                           HttpServletRequest request, @ApiParam(value = "端口：0小程序 1后台") @RequestParam(value = "port") Integer port) {
        return contractService.file(contractId, this.getUserLoginInfoFromRedis(request), port);
    }

    @ApiOperation(value = "根据订单编号数组获取合同的信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ContractInfoDTO.class)})
    @PostMapping("/listContractInfoByOrderNo")
    public List<ContractInfoDTO> getContractInfo(@ApiParam(value = "订单编号list") @RequestBody List<String> orderNos) {
        return contractService.listContractInfoByOrderNo(orderNos);
    }
}
