package com.mmc.iuav.user.model.dto.dronepilot;

import com.mmc.iuav.user.model.vo.dronepilot.BaseEnum;
import lombok.Getter;

/**
 * @Author small
 * @Date 2023/7/28 9:42
 * @Version 1.0
 */
@Getter
public enum LicenseType implements BaseEnum {

    CAAC("CAAC", "CAAC"),
    UTC("UTC", "UTC"),
    OTHER("OTHER", "OTHER");


    private String code;
    private String desc;

    private LicenseType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getdesc() {
        return desc;
    }

    public void setdesc(String desc) {
        this.desc = desc;
    }

    public static LicenseType match(String key) {

        LicenseType result = null;

        for (LicenseType s : values()) {
            if (s.getCode() == key) {
                result = s;
                break;
            }
        }

        return result;
    }

    public static LicenseType catchdesc(String msg) {

        LicenseType result = null;

        for (LicenseType s : values()) {
            if (s.getdesc().equals(msg)) {
                result = s;
                break;
            }
        }

        return result;
    }


    @Override
    public String getEnumCode() {
        return code;
    }

    @Override
    public String getEnumDesc() {
        return desc;
    }
}
