package com.mmc.iuav.user.service.fdd;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.fdd.dto.ContractInfoDTO;
import com.mmc.iuav.user.model.fdd.vo.ContractVO;

import java.util.List;
import java.util.Map;

/**
 * @Author LW
 * @date 2022/9/5 14:38
 * 概要：
 */
public interface ContractService {
    /**
     * 上传合同
     *
     * @param param
     * @param id
     * @return
     */
    ResultBody uploadContract(ContractVO param, LoginSuccessDTO loginSuccessDTO);

    ResultBody viewContract(String contractId);

    ResultBody downloadContract(String contractId);

    ResultBody stamp(String contractId, LoginSuccessDTO loginSuccessDTO, String pages, Integer port);

    /**
     * 异步回调
     *
     * @param map
     * @return
     */
    ResultBody notifyStamp(Map<String, String> map);

    ResultBody file(String contractId, LoginSuccessDTO loginSuccessDTO, Integer port);

    List<ContractInfoDTO> listContractInfoByOrderNo(List<String> orderNos);
}
