package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.*;
import com.mmc.iuav.user.model.qo.ApplyQO;
import com.mmc.iuav.user.model.vo.AppUserTagVO;
import com.mmc.iuav.user.model.vo.ApplyTagEditVO;
import com.mmc.iuav.user.model.vo.AttachmentVO;
import com.mmc.iuav.user.model.vo.UserApplyTagVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * @author: zj @Date: 2023/5/17 21:20
 */
@Mapper
public interface CooperationDao {
    /**
     * 加盟标签列表
     *
     * @return
     */
    List<CooperationTagDO> listTags();

    /**
     * 加盟申请
     *
     * @param userApplyTagDO
     */
    void addApply(UserApplyTagDO userApplyTagDO);

    /**
     * 根据id获取合作申请
     *
     * @param id
     * @return
     */
    UserApplyTagDO getUserApplyTag(Integer id);

    UserApplyTagDO getUserApplyTagByCompanyId(Integer companyId);

    /**
     * 根据合同编号查询用户
     * @param contractNo
     * @return {@link UserApplyTagDO}
     */
    UserApplyTagDO getUserApplyTagByContractId(String contractNo);

    /**
     * 修改用户申请
     *
     * @param userApplyTagDO
     */
    void updateUserApplyTag(UserApplyTagDO userApplyTagDO);

    /**
     * 根据用户id查询合作标签信息
     *
     * @param userAccountId
     * @return
     */
    List<CooperationTagDO> listUserCooperationTag(Integer userAccountId);

    /**
     * 用户设置渠道等级
     *
     * @param userTagDO
     */
    void insertUserTag(UserTagDO userTagDO);

    /**
     * 修改用户渠道等级
     *
     * @param userTagDO
     */
    void updateUserTag(UserTagDO userTagDO);

    /**
     * 根据id查询标签信息
     *
     * @param id
     * @return
     */
    CooperationTagDO getTagById(Integer id);

    /**
     * 添加加盟入驻的附件资源
     *
     * @param tagApplyResourceDO 标签应用资源做
     */
    void addApplyResource(TagApplyResourceDO tagApplyResourceDO);

    int countListUserApplyTag(ApplyQO applyQO);

    List<UserApplyTagDO> listUserApplyTag(ApplyQO applyQO);

    UserApplyTagDO getContractNoAndStatus(Integer tagId, Integer userAccountId);
    Integer getAuditSum(Integer status);


    void deleteApplyTag(Integer id);

    List<TagApplyResourceDO> getUserApplyResource(Integer id);

    void updateApplyTagStatus(Integer id, int i);

    int userTagInfo(Integer cooperationTagId, Integer userAccountId);

    /**
     * 删除用户原来的标签
     *
     * @param userAccountId
     */
    void removeUserTag(Integer userAccountId);

    /**
     * 添加用户合作加盟标签
     *
     * @param userAccountId
     * @param cooperationTagIds
     */
    void batchInsertUserTag(Integer userAccountId, Set<Integer> cooperationTagIds);

    /**
     * 根据用户id查询用户拥有的合作标签
     *
     * @param uIds
     * @return
     */
    List<CooperationTagDO> listUserCooperationTagByUIds(@Param("uIds") List<Integer> uIds);

    void addWebsiteInfo(ApplyTagEditVO applyTagEditVO);

    int countServiceBitmapData(Integer type);

    List<WebsiteInfoDO> listServiceBitmapData(Integer type, Double lon, Double lat, int pageNo, Integer pageSize);

    void updateWebsiteInfo(ApplyTagEditVO applyTagEditVO);

    WebsiteInfoDO getWebsiteInfoByUserApplyId(Integer id);

    void deleteApplyResource(Integer id);

    void insertApplyResource(List<AttachmentVO> list);

    void updateCompanyInfo(UserApplyTagDO userApplyTagDO);

    List<CompanyInfoDO> appBrandList();

    int countUserApplyTagByUid(Integer userAccountId);

    UserApplyTagDO appBrandMessage(Integer userAccountId);

    List<AppUserTagVO> getTagIdByUserId(Integer userAccountId);
    int countListCompanyInfoByCoopId(Integer coopId);

    List<CompanyInfoDO> listCompanyInfoByCoopId(Integer coopId, Double lon, Double lat, Integer pageNo, Integer pageSize);

    int getJoinStoreCount();

    int getStoreCountByType(int type);

    //查到标签绑定之前的用户
    UserApplyTagDO selectTageByUserId(Integer fromUserAccountId);
}
