package com.mmc.iuav.user.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/7/11 14:04
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RoleMenuInfoVO implements Serializable {
    private static final long serialVersionUID = -8669403169556374845L;
    @ApiModelProperty(value = "角色id")
    @NotNull
    private Integer roleId;
    @ApiModelProperty(value = "菜单ids")
    @NotNull
    @Size(min = 1, message = "角色菜单需选择1个以上")
    private List<Integer> menuInfoIds;
}
