package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.SystemMessageDO;
import com.mmc.iuav.user.entity.UserMessageDO;
import com.mmc.iuav.user.entity.UserMessageLogDO;
import com.mmc.iuav.user.model.qo.MessageQO;
import com.mmc.iuav.user.model.qo.MessageUserQO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* @author han
* @createDate 2023-12-14 10:46:45
*/
@Mapper
public interface MessageDao {

    /**
     * 添加系统消息
     * @param messageDO
     * @return
     */
    int insertSystemMessage(SystemMessageDO messageDO);

    /**
     * 修改系统消息
     * @param messageDO
     * @return
     */
    int updateSystemMessage(SystemMessageDO messageDO);

    /**
     * 根据ID查询系统消息
     * @param id
     * @return
     */
    SystemMessageDO selectSystemMessageById(Integer id);

    /**
     * 查询所有的系统消息
     * @return
     */
    List<SystemMessageDO> selectAllSystemMessage(MessageQO messageQO);

    int countSystemMessage();

    /**
     * 删除消息
     * @param id
     * @return
     */
    int removeMessage(Integer id);

    /**
     * 查询用户是否读取过
     */
    int selectReceiverMessage(@Param("userId") Integer userId,@Param("messageId") Integer messageId);

    /**
     * 添加用户读取过得信息
     * @param userId
     * @param messageId
     * @return
     */
    int insertReceiverMessage(@Param("userId") Integer userId,@Param("messageId") Integer messageId);

    /**
     * 删除读取过的消息
     * @param id
     * @return
     */
    int removeReceiverMessage(@Param("userId") Integer userId,@Param("messageId") Integer messageId);

    /**
     * 根据messageId删除接收方的消息(撤回删除消息之后,接收方应该不能查看)
     */
    int removeReceiverMessageByMessageId(@Param("messageId") Integer messageId);
    /**
     * 查询读取过但是已经被用户删除的信息
     * @param userId
     * @param messageId
     * @return
     */
    int selectReceiverMessageByDel(@Param("userId") Integer userId,@Param("messageId") Integer messageId);

    /**
     * 添加用户消息
     * @param messageDO
     * @return
     */
    int insertUserMessage(UserMessageDO messageDO);

    List<UserMessageDO> selectUserMessage(@Param("messageQO")MessageUserQO messageQO,@Param("senderUserId")Integer  senderUserId);
    UserMessageDO selectEndUserMessage(@Param("receiverUserId") Integer receiverUserId,@Param("senderUserId")Integer  senderUserId);

    int countUserMessage(@Param("receiverUserId") Integer receiverUserId,@Param("senderUserId") Integer senderUserId);

    List<Integer> selectUserListBySenderUserId(@Param("senderUserId")Integer  senderUserId);
    List<Integer> selectUserListByReceiverUserId(@Param("senderUserId")Integer  senderUserId);

    int removeUserMessage(Integer id);

    int insertUserMessageLog(UserMessageLogDO userMessageLogDO);
    Integer isUserMessageLog(@Param("receiverUserId") Integer receiverUserId,@Param("senderUserId") Integer senderUserId);

    int updateUserMessageLog(@Param("id") Integer logId);
    int updateUserMessageCount(@Param("id") Integer logId);

    int removeUserMessageCount(@Param("id") Integer logId);
    List<UserMessageLogDO> selectUserList(@Param("senderUserId") Integer senderUserId);

    void removeUserMessageLog(@Param("id") Integer logId);
    UserMessageDO selectUserMessageById(@Param("id") Integer id);
}
