package com.mmc.iuav.user.entity.wallet;

import com.mmc.iuav.user.model.dto.wallet.PayWalletDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 用户钱包(PayWalletDO)实体类
 *
 * @author makejava
 * @since 2023-08-18 13:23:57
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PayWalletDO implements Serializable {
    private static final long serialVersionUID = 234037599702985920L;

    private Integer id;
    /**
     * 版本号
     */
    private Integer pid;

    private Integer userAccountId;
    /**
     * 云享金余额
     */
    private BigDecimal cashAmt;
    /**
     * 已付云享金
     */
    private BigDecimal cashPaid;
    /**
     * 已冻结云享金
     */
    private BigDecimal cashFreeze;
    /**
     * 佣金余额
     */
    private BigDecimal salaryAmt;
    /**
     * 已付佣金
     */
    private BigDecimal salaryPaid;
    /**
     * 已冻结佣金
     */
    private BigDecimal salaryFreeze;

    private BigDecimal wxCashFreeze;

    /**
     * 提现总额
     */
    private BigDecimal salaryWdl;

    private Date createTime;

    private Date updateTime;

    public PayWalletDTO buildPayWalletDTO() {
        return PayWalletDTO.builder().id(this.id).userAccountId(this.userAccountId)
                .cashAmt(this.cashAmt).cashFreeze(this.cashFreeze)
                .cashPaid(this.cashPaid).salaryAmt(this.salaryAmt)
                .salaryFreeze(this.salaryFreeze).salaryPaid(this.salaryPaid)
                .rebateWdl(this.salaryWdl).build();
    }

    public void defaultValue() {
        this.cashAmt = BigDecimal.ZERO;
        this.cashPaid = BigDecimal.ZERO;
        this.cashFreeze = BigDecimal.ZERO;
        this.salaryAmt = BigDecimal.ZERO;
        this.salaryPaid = BigDecimal.ZERO;
        this.salaryFreeze = BigDecimal.ZERO;
        this.salaryWdl = BigDecimal.ZERO;
        this.wxCashFreeze = BigDecimal.ZERO;
    }
}

