package com.mmc.iuav.user.controller.wallet;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.dto.wallet.PayWalletDTO;
import com.mmc.iuav.user.model.vo.wallet.WalletFlowVO;
import com.mmc.iuav.user.service.wallet.PayWalletService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 * @date 2023/8/18 11:33
 * 概要：
 */
@Api(tags = "V1.0.3-用户钱包-相关接口")
@RequestMapping("/pay/")
@RestController
public class PayWalletController extends BaseController {

    @Resource
    PayWalletService payWalletService;

    @ApiOperation(value = "获取当前用户消费(钱包)信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PayWalletDTO.class)})
    @GetMapping("getCurrentUserPayWalletInfo")
    public ResultBody getCurrentUserPayWalletInfo(HttpServletRequest request) {
        return payWalletService.getPayWalletInfo(this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "获取用户消费(钱包)信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PayWalletDTO.class)})
    @GetMapping("getPayWalletInfo")
    public ResultBody getPayWalletInfo(
            @ApiParam(value = "用户userAccountId", required = true) @RequestParam Integer userAccountId) {
        return ResultBody.success(payWalletService.getPayWalletInfo(userAccountId));
    }

    @ApiOperation(value = "feign-初始化钱包")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @ApiIgnore
    @GetMapping("feignInitPayWallet")
    public ResultBody feignInitPayWallet(@RequestParam Integer userAccountId) {
        return payWalletService.initPayWallet(userAccountId);
    }

    @ApiOperation(value = "feign-云享金充值接口")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @ApiIgnore
    @GetMapping("feignTopUpCash")
    public ResultBody feignTopUpCash(@RequestParam Integer userAccountId) {
//        return payWalletService.feignTopUpCash(userAccountId);
        return null;
    }


    @ApiOperation(value = "feign-钱包流水记录")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("feignWalletFlow")
    public ResultBody feignWalletFlow(@RequestBody WalletFlowVO walletFlowVO) {
        return payWalletService.feignWalletFlow(walletFlowVO);
    }
}
