package com.mmc.iuav.user.auth;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.util.PathUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

/**
 * @author: zj
 * @Date: 2023/5/28 10:46
 */
@Component
public class TokenCheckHandleInterceptor implements HandlerInterceptor {

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private NotCheckUriConfig notCheckUriConfig;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestURI = request.getRequestURI();
        //根据uri确认是否要拦截
        if (!shouldFilter(requestURI)){
            return true;
        }
        String token = request.getHeader("token");
        String tokenJson = stringRedisTemplate.opsForValue().get(token);

        if (StringUtils.isBlank(tokenJson)){
            exceptionProcess(response);
            return false;
        }
        LoginSuccessDTO loginSuccessDTO = JSONObject.parseObject(tokenJson, LoginSuccessDTO.class);
        if (loginSuccessDTO != null){
            request.setAttribute("userAccountId", loginSuccessDTO.getUserAccountId());
        }
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public void exceptionProcess(HttpServletResponse response) throws Exception{
        response.setContentType("application/json;charset=utf-8");
        PrintWriter writer=response.getWriter();
        writer.write(ResultBody.error(ResultEnum.LOGIN_ACCOUNT_STATUS_ERROR).toString());
        writer.close();
    }

    private boolean shouldFilter(String path) {
        // 路径与配置的相匹配，则执行过滤
        for (String pathPattern : notCheckUriConfig.getNotAuthPath()) {
            if (PathUtil.isPathMatch(pathPattern, path)) {
                // 如果匹配
                return false;
            }
        }
        return true;
    }
}
