package com.mmc.iuav.user.util;


import com.google.gson.Gson;
import com.mmc.iuav.user.entity.UserDO;
import com.mmc.iuav.user.service.WxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@Component
public class ScheduledTaskUtil {
    @Autowired
    private StringRedisTemplate redisTemplate;


    @Autowired
    private TaskScheduler taskScheduler;

    @Autowired
    private WxService wxService;

    private final Map<Integer, ScheduledFuture<?>> scheduledTasks = new ConcurrentHashMap<>();

    public void create(UserDO userDO){
        long delay = 600000; // 延迟10分钟开始执行
        MyTask task = new MyTask();
        task.setUserDO(userDO);
//        task.setWxService(wxService);
        redisTemplate.setValueSerializer(RedisSerializer.json());
        redisTemplate.opsForValue().set("task" + userDO.getUserAccountId() + Instant.now(), new Gson().toJson(task), delay, TimeUnit.MILLISECONDS);

        // 使用TaskScheduler执行定时任务
        System.out.println("定时任务已开启");
        ScheduledFuture<?> scheduledFuture = taskScheduler.schedule(task, Instant.now().plusMillis(delay));
        scheduledTasks.put(userDO.getUserAccountId(), scheduledFuture);
    }

    public void destroy(Integer userAccountId){
        redisTemplate.setValueSerializer(RedisSerializer.json());
        Set<String> keys = redisTemplate.keys("task" + userAccountId + "*");
        if(keys == null || keys.isEmpty()){
            return;
        }
        for (String key : keys) {
            String s = redisTemplate.opsForValue().get(key);
            MyTask task = new Gson().fromJson(s, MyTask.class);
            ScheduledFuture<?> scheduledFuture = scheduledTasks.get(userAccountId);
            if (task != null && scheduledFuture != null) {
                scheduledFuture.cancel(false);
                redisTemplate.delete(key);
                scheduledTasks.remove(userAccountId);
            }
        }
        System.out.println("定时任务已取消");
//        String s = redisTemplate.opsForValue().get("task" + userAccountId);
//        if(s == null || s == ""){
//            return;
//        }

    }
}
