package com.mmc.iuav.user.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Email;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/6/21 17:32
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BackUserAccountVO implements Serializable {
    private static final long serialVersionUID = -9128622882856324055L;
    @ApiModelProperty(value = "用户id")
    private Integer id;
    @ApiModelProperty(value = "用户uid")
    private Integer uid;
    @ApiModelProperty(value = "用户账号")
    private String accountNo;
    @ApiModelProperty(value = "手机号")
    private String phoneNum;
    @ApiModelProperty(value = "用户名称")
    private String userName;
    @ApiModelProperty(value = "用户昵称")
    private String nickName;
    @ApiModelProperty(value = "用户头像")
    private String userImg;
    @ApiModelProperty(value = "用户性别：0未知、1男、2女")
    private Integer userSex;
    @ApiModelProperty(value = "用户邮箱")
    @Email
    private String email;
    @ApiModelProperty(value = "用户可用状态：0禁用、1可用")
    private Integer accountStatus;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "注册时间")
    private Date createTime;
    @ApiModelProperty(value = "企业认证状态, 0未通过，1通过")
    private Integer companyAuthStatus;
    @ApiModelProperty(value = "合作标签id")
    private Integer cooperationTagId;
    @ApiModelProperty(value = "企业名称")
    private String companyName;
    @ApiModelProperty(value = "合作标签名称")
    private String tagName;
    @ApiModelProperty(value = "地址")
    private String address;
    @ApiModelProperty(value = "单位信息")
    private CompanyInfoVO companyInfoVO;
}
