package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.UserAccountDO;
import com.mmc.iuav.user.entity.UserRcdDO;
import com.mmc.iuav.user.model.qo.UserAccountQO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/16 19:26
 */
@Mapper
public interface UserServiceDao {
    /**
     * 根据用户unionId查询用户信息
     *
     * @param unionId
     * @return
     */
    UserAccountDO getUserAccountInfoByUnionId(String unionId);

    /**
     * 插入用户信息
     *
     * @param userAccountDO
     */
    void insertUserAccount(UserAccountDO userAccountDO);

    /**
     * 根据用户id查询用户信息
     *
     * @param userAccountId
     * @return
     */
    UserAccountDO getUserAccountById(Integer userAccountId);

    /**
     * 修改用户信息
     *
     * @param userAccountDO
     */
    void update(UserAccountDO userAccountDO);

    /**
     * 根据用户地区查询后台用户id
     *
     * @param provinceCode
     * @param cityCode
     * @param districtCode
     * @return
     */
    List<Integer> listUserAccountIdsByDistrictCode(Integer provinceCode, Integer cityCode, Integer districtCode);

    /**
     * 批量获取用户信息
     *
     * @param userAccountQO
     * @return
     */
    List<UserAccountDO> feignListUserAccount(UserAccountQO userAccountQO);

    /**
     * 禁用用户（原删除）
     *
     * @param removeNO
     * @param userAccountId
     */
    void disableUserAccount(String removeNO, Integer userAccountId);

    /**
     * 根据id查询用户信息
     *
     * @param userIds
     * @return
     */
    List<UserAccountDO> listUserAccountByIds(@Param("userIds") List<Integer> userIds);

    /**
     * 获取用户推荐人信息
     *
     * @param userIds
     * @return
     */
    List<UserAccountDO> feignListRcdUserInfo(@Param("userIds") List<Integer> userIds);

    /**
     * 获取推荐人信息
     *
     * @param userAccountId
     * @return
     */
    UserAccountDO getUserRcdByAccountId(Integer userAccountId);

    /**
     * 获取用户推荐信息
     *
     * @param userAccountId
     * @return
     */
    UserRcdDO getUserRcdDO(Integer userAccountId);

    /**
     * 用户数量
     *
     * @param param
     * @return
     */
    int countListAppUser(UserAccountQO param);

    /**
     * 用户信息
     *
     * @param param
     * @return
     */
    List<UserAccountDO> listAppUser(UserAccountQO param);

}
