package com.mmc.iuav.user.model.qo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.domain.Page;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @Author LW
 *
 * @date 2023/6/27 14:59 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ApplyQO {
  @ApiModelProperty(value = "申请加盟类型", example = "1")
  private Integer cooperationTagId;

  @ApiModelProperty(value = "申请状态", example = "0")
  private Integer applyStatus;

  @ApiModelProperty(value = "开始时间", example = "2023-01-01 00:00:00")
  private String startTime;

  @ApiModelProperty(value = "结束时间", example = "2023-12-31 23:59:59")
  private String endTime;

  @ApiModelProperty(value = "页码", required = true, example = "1")
  @NotNull(message = "页码不能为空", groups = Page.class)
  @Min(value = 1, groups = Page.class)
  private Integer pageNo;

  @ApiModelProperty(value = "每页显示数", required = true, example = "10")
  @NotNull(message = "每页显示数不能为空", groups = Page.class)
  @Min(value = 1, groups = Page.class)
  private Integer pageSize;

  public void buildCurrentPage() {
    this.pageNo = (pageNo - 1) * pageSize;
  }
}
