package com.mmc.iuav.user.service;

import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.qo.MessageQO;
import com.mmc.iuav.user.model.qo.MessageUserQO;
import com.mmc.iuav.user.model.vo.MessageTimePointsVO;
import com.mmc.iuav.user.model.vo.MessageTimeVO;
import com.mmc.iuav.user.model.vo.SystemMessageVO;
import com.mmc.iuav.user.model.vo.UserMessageVO;

public interface MessageService {
    /**
     * 添加系统消息
     * @param messageVO
     * @return
     */
    ResultBody insertSystemMessage(SystemMessageVO messageVO);

    /**
     * 根据ID查询系统消息
     * @param id
     * @return
     */
    ResultBody selectSystemMessageById(Integer id);

    /**
     * 后台发布——系统消息列表
     * 查询所有的系统消息
     * @return
     */
    PageResult selectAllSystemMessage(MessageQO messageQO);

    /**
     * 删除消息
     * @param id
     * @return
     */
    ResultBody removeMessage(Integer id);

    /**
     * 用户接收——系统消息列表
     * 查询所有的系统消息
     * @return
     */
    PageResult selectAllSystemMessageByReceive(Integer userId, MessageQO messageQO);

    /**
     * 用户查看——系统消息详情
     * @return
     */
    ResultBody showSystemMessageByUser(Integer userId, Integer messageId);

    /**
     * 用户——删除用户接收的消息
     * @param id
     * @return
     */
    ResultBody removeMessageByUser(Integer userId, Integer messageId);

    /**
     * 添加用户消息
     * @param messageVO
     * @return
     */
    ResultBody insertUserMessage(UserMessageVO messageVO,Integer senderUserId);


    /**
     * 查看用户是否购买聊天时长
     * @param UserId
     * @return {@link ResultBody}
     */
    ResultBody isPurchaseTime(Integer UserId);



    PageResult selectUserMessage(MessageUserQO messageQO,Integer senderUserId);

    ResultBody selectUserList(Integer senderUserId);

    ResultBody removeUserMessage(Integer id);

    ResultBody removeUser(Integer senderUserId, Integer receiverUserId);

//    ResultBody purchaseTime(Integer userAccountId, MessageTimeVO messageTimeVO, String token);

    ResultBody purchaseTimeByPoints(Integer userAccountId, MessageTimePointsVO messageTimeVO);
    ResultBody purchaseTimeByWechat(Integer userAccountId,  Integer id);
    ResultBody listTimeType();

    ResultBody updateTimeType(MessageTimeVO messageTimeVO);

    ResultBody insertTimeType(MessageTimeVO messageTimeVO);

    Integer timeTypeById(Integer id,Integer userId);
}
